<?php

// config/tenant-sidebar.php
return [
    'main_menu' => [
        'dashboard' => [
            'type' => 'item',
            'label' => 'dashboard',
            'route' => 'tenant.dashboard',
            'icon' => 'heroicon-o-squares-2x2',
            'permission' => null,
            'order' => 1,
            'active_routes' => ['tenant.dashboard'],
            'badge' => null,
            'external' => false,
        ],

        'connect_waba' => [
            'type' => 'item',
            'label' => 'connect_waba',
            'route' => 'tenant.connect',
            'icon' => 'heroicon-o-link',
            'permission' => 'tenant.connect_account.connect',
            'order' => 2,
            'active_routes' => ['tenant.connect', 'tenant.waba'],
            'badge' => null,
            'external' => false,
            'visible_when' => 'App\Services\Sidebar\SidebarVisibilityService::isWhatsAppNotConnected',
        ],

        'waba_connected' => [
            'type' => 'item',
            'label' => 'connect_waba',
            'route' => 'tenant.waba',
            'icon' => 'heroicon-o-link',
            'permission' => 'tenant.connect_account.view',
            'order' => 2,
            'active_routes' => ['tenant.waba'],
            'badge' => null,
            'external' => false,
            'visible_when' => 'App\Services\Sidebar\SidebarVisibilityService::isWhatsAppConnected',
        ],

        'chat' => [
            'type' => 'item',
            'label' => 'chat',
            'route' => 'tenant.chat',
            'icon' => 'heroicon-o-chat-bubble-oval-left',
            'permission' => ['tenant.chat.view', 'tenant.chat.read_only'],
            'order' => 3,
            'active_routes' => ['tenant.chat'],
            'feature_required' => 'conversations',
            'badge' => null,
            'external' => false,
        ],

        'bot_flow' => [
            'type' => 'item',
            'label' => 'bot_flow',
            'route' => 'tenant.bot-flow_list',
            'icon' => 'carbon-flow',
            'permission' => ['tenant.bot_flow.view', 'tenant.bot_flow.create'],
            'order' => 4,
            'active_routes' => ['tenant.bot-flow_list', 'tenant.bot-flows.edit'],
            'feature_required' => 'bot_flow',
            'badge' => null,
            'external' => false,
        ],

        'contact_section' => [
            'type' => 'section',
            'label' => 'contact',
            'icon' => 'heroicon-o-user-circle',
            'permission' => ['tenant.contact.view', 'tenant.contact.view_own'],
            'permission_type' => 'any',
            'order' => 6,
            'section_id' => 'contact',
            'feature_required' => 'contacts',
            'default_expanded' => true,
            'children' => [
                'contacts' => [
                    'type' => 'item',
                    'label' => 'contact',
                    'route' => 'tenant.contacts.list',
                    'icon' => null,
                    'permission' => ['tenant.contact.view', 'tenant.contact.view_own'],
                    'permission_type' => 'any',
                    'order' => 1,
                    'active_routes' => ['tenant.contacts.*'],
                    'feature_required' => 'contacts',
                ],
            ],
        ],

        'templates_section' => [
            'type' => 'section',
            'label' => 'templates',
            'icon' => 'heroicon-o-document',
            'permission' => 'tenant.template.view',
            'order' => 7,
            'section_id' => 'templates',
            'default_expanded' => true,
            'children' => [
                'templates' => [
                    'type' => 'item',
                    'label' => 'templates',
                    'route' => 'tenant.template.list',
                    'icon' => null,
                    'permission' => 'tenant.template.view',
                    'order' => 1,
                    'active_routes' => ['tenant.template.list'],
                ],
            ],
        ],

        'marketing_section' => [
            'type' => 'section',
            'label' => 'marketing',
            'icon' => 'heroicon-o-megaphone',
            'permission' => ['tenant.campaigns.view', 'tenant.bulk_campaigns.send', 'tenant.message_bot.view', 'tenant.template_bot.view'],
            'permission_type' => 'any',
            'order' => 8,
            'section_id' => 'marketing',
            'default_expanded' => false,
            'children' => [
                'campaigns' => [
                    'type' => 'item',
                    'label' => 'campaign',
                    'route' => 'tenant.campaigns.list',
                    'icon' => null,
                    'permission' => 'tenant.campaigns.view',
                    'order' => 1,
                    'active_routes' => ['tenant.campaigns.list', 'tenant.campaign'],
                    'feature_required' => 'campaigns',
                ],
                'bulk_campaign' => [
                    'type' => 'item',
                    'label' => 'bulk_campaign',
                    'route' => 'tenant.csvcampaign',
                    'icon' => null,
                    'permission' => 'tenant.bulk_campaigns.send',
                    'order' => 2,
                    'active_routes' => ['tenant.csvcampaign'],
                ],
                'message_bot' => [
                    'type' => 'item',
                    'label' => 'message_bot',
                    'route' => 'tenant.messagebot.list',
                    'icon' => null,
                    'permission' => 'tenant.message_bot.view',
                    'order' => 3,
                    'active_routes' => ['tenant.messagebot.*'],
                    'feature_required' => 'message_bots',
                ],
                'template_bot' => [
                    'type' => 'item',
                    'label' => 'template_bot',
                    'route' => 'tenant.templatebot.list',
                    'icon' => null,
                    'permission' => 'tenant.template_bot.view',
                    'order' => 4,
                    'active_routes' => ['tenant.templatebot.*'],
                    'feature_required' => 'template_bots',
                ],

            ],
        ],

        'support_section' => [
            'type' => 'section',
            'label' => 'support',
            'icon' => 'heroicon-o-ticket',
            'permission' => ['tenant.tickets.index'],
            'order' => 9,
            'section_id' => 'support',
            'default_expanded' => false,
            'children' => [
                'support_tickets' => [
                    'type' => 'item',
                    'label' => 'support_tickets',
                    'route' => 'tenant.tickets.index',
                    'icon' => null,
                    'permission' => null,
                    'order' => 2,
                    'active_routes' => ['tenant.tickets.*'],
                    'visible_when' => 'App\Services\Sidebar\SidebarVisibilityService::isTicketsModuleEnabled',
                ],
            ],
        ],

        'settings_section' => [
            'type' => 'section',
            'label' => 'settings',
            'icon' => 'heroicon-o-cog',
            'permission' => null,
            'order' => 10,
            'section_id' => 'settings',
            'default_expanded' => false,
            'children' => [
                'whatsmark_settings' => [
                    'type' => 'item',
                    'label' => 'application_settings',
                    'route' => 'tenant.settings.whatsapp-auto-lead',
                    'icon' => null,
                    'permission' => 'tenant.whatsmark_settings.view',
                    'permission_type' => null,
                    'order' => 1,
                    'active_routes' => [
                        'tenant.settings.whatsapp-auto-lead',
                        'tenant.settings.stop-bot',
                        'tenant.settings.web-hooks',
                        'tenant.settings.support-agent',
                        'tenant.settings.notification-sound',
                        'tenant.settings.ai-integration',
                        'tenant.settings.auto-clear-chat-history',
                        'tenant.settings.whatsapp-web-hooks',
                        'tenant.settings.opt-in-out',
                        'tenant.settings.whatsapp-session-management',
                    ],
                ],
                'system_settings' => [
                    'type' => 'item',
                    'label' => 'system_settings',
                    'route' => 'tenant.settings.general',
                    'icon' => null,
                    'permission' => 'tenant.system_settings.view',
                    'permission_type' => null,
                    'order' => 2,
                    'active_routes' => [
                        'tenant.settings.general',
                        'tenant.settings.email',
                        'tenant.settings.cache-management',
                    ],
                ],
            ],
        ],
    ],

    // Setup menu configuration
    'setup_menu' => [
        'staff' => [
            'type' => 'item',
            'label' => 'staff',
            'route' => 'tenant.staff.list',
            'icon' => 'heroicon-o-users',
            'permission' => 'tenant.staff.view',
            'order' => 1,
            'active_routes' => ['tenant.staff.*'],
            'feature_required' => 'staff',
        ],
        'roles' => [
            'type' => 'item',
            'label' => 'role',
            'route' => 'tenant.roles.list',
            'icon' => 'heroicon-o-swatch',
            'permission' => 'tenant.role.view',
            'order' => 2,
            'active_routes' => ['tenant.roles.*'],
            'visible_when' => 'App\Services\Sidebar\SidebarVisibilityService::isTenantAdmin',
        ],
        'status' => [
            'type' => 'item',
            'label' => 'status',
            'route' => 'tenant.status',
            'icon' => 'heroicon-c-adjustments-horizontal',
            'permission' => 'tenant.status.view',
            'order' => 3,
            'active_routes' => ['tenant.status'],
        ],
        'source' => [
            'type' => 'item',
            'label' => 'source',
            'route' => 'tenant.source',
            'icon' => 'heroicon-o-square-3-stack-3d',
            'permission' => 'tenant.source.view',
            'order' => 4,
            'active_routes' => ['tenant.source'],
        ],
        'groups' => [
            'type' => 'item',
            'label' => 'groups',
            'route' => 'tenant.groups.list',
            'icon' => 'heroicon-o-user-group',
            'permission' => 'tenant.group.view',
            'order' => 5,
            'active_routes' => ['tenant.groups.list'],
        ],
        'custom_fields' => [
            'type' => 'item',
            'label' => 'custom_fields',
            'route' => 'tenant.custom-fields.list',
            'icon' => 'heroicon-o-adjustments-vertical',
            'permission' => 'tenant.custom_fields.view',
            'order' => 6,
            'active_routes' => ['tenant.custom-fields.*'],
        ],
        'ai_prompts' => [
            'type' => 'item',
            'label' => 'ai_prompts',
            'route' => 'tenant.ai-prompt',
            'icon' => 'heroicon-o-rocket-launch',
            'permission' => 'tenant.ai_prompt.view',
            'order' => 7,
            'active_routes' => ['tenant.ai-prompt'],
            'feature_required' => 'ai_prompts',
        ],
        'canned_reply' => [
            'type' => 'item',
            'label' => 'canned_reply',
            'route' => 'tenant.canned-reply',
            'icon' => 'heroicon-m-arrow-right-on-rectangle',
            'permission' => 'tenant.canned_reply.view',
            'order' => 8,
            'active_routes' => ['tenant.canned-reply'],
            'feature_required' => 'canned_replies',
        ],
        'activity_log' => [
            'type' => 'item',
            'label' => 'activity_log',
            'route' => 'tenant.activity-log.list',
            'icon' => 'heroicon-s-arrow-path',
            'permission' => 'tenant.activity_log.view',
            'order' => 9,
            'active_routes' => ['tenant.activity-log.list'],
        ],
        'languages' => [
            'type' => 'item',
            'label' => 'languages',
            'route' => 'tenant.languages',
            'icon' => 'heroicon-s-language',
            'permission' => null,
            'order' => 10,
            'active_routes' => ['tenant.languages'],
            'visible_when' => 'App\Services\Sidebar\SidebarVisibilityService::isTenantAdmin',
        ],
        'email_templates' => [
            'type' => 'item',
            'label' => 'email_template_list_title',
            'route' => 'tenant.emails',
            'icon' => 'heroicon-o-envelope',
            'permission' => 'tenant.email_template.view',
            'order' => 11,
            'active_routes' => ['tenant.emails', 'tenant.emails.save'],
        ],
        'system_logs' => [
            'type' => 'item',
            'label' => 'system_logs',
            'route' => 'tenant.logs.index',
            'icon' => 'heroicon-o-document-chart-bar',
            'permission' => null,
            'order' => 12,
            'active_routes' => ['tenant.logs.index'],
            'visible_when' => 'App\Services\Sidebar\SidebarVisibilityService::canViewTenantLogs',
        ],
    ],
];
