<?php

use Spatie\LaravelSettings\Migrations\SettingsMigration;

return new class extends SettingsMigration
{
    protected array $settings = [
        'theme.partners_logos_enabled' => true,
        'theme.partners_logo_header' => 'Trusted by Leading Companies',
        'theme.partners_logo_description' => 'Join thousands of satisfied clients who trust our platform for their business growth',
        'theme.partners_logo_footer' => 'Top companies trust our platform worldwide',

    ];

    public function up(): void
    {
        foreach ($this->settings as $key => $value) {
            if (! $this->migrator->exists($key)) {
                $this->migrator->add($key, $value);
            }
        }
    }

    public function down(): void
    {
        foreach (array_keys($this->settings) as $key) {
            if ($this->migrator->exists($key)) {
                $this->migrator->delete($key);
            }
        }
    }
};
