<?php

namespace Modules\Tickets\Models {

	/**
	 * Modules\Tickets\Models\Ticket
	 *
	 * @property \Illuminate\Support\Carbon|null $closed_at
	 * @property string $body
	 * @property array|null $attachments
	 * @property boolean $tenant_viewed
	 * @property boolean $admin_viewed
	 * @property string $ticket_id
	 * @property mixed $status
	 * @property mixed $priority
	 * @property int $department_id
	 * @property string $subject
	 * @property int|null $tenant_staff_id
	 * @property int|null $tenant_id
	 * @property int $id
	 * @property-read mixed $assignee_id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read mixed $title
	 * @property-read mixed $ticket_number
	 * @property-read \Modules\Tickets\Models\Department $department
	 * @property-read \App\Models\Tenant $tenant
	 * @property-read \App\Models\User $tenantStaff
	 * @property-read \App\Models\User $assignedUser
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Modules\Tickets\Models\TicketReply> $replies
	 * @property-read int|null $replies_count
	 * @property-read \Modules\Tickets\Models\TicketReply $latestReply
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\User> $assignedUsers
	 * @property-read int|null $assignedUsers_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereTenantStaffId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereSubject($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereDepartmentId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket wherePriority($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereStatus($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereTicketId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereAdminViewed($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereTenantViewed($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereAttachments($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereBody($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereClosedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket byStatus(string $status) {@see Modules\Tickets\Models\Ticket::scopeByStatus()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket byPriority(string $priority) {@see Modules\Tickets\Models\Ticket::scopeByPriority()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket open() {@see Modules\Tickets\Models\Ticket::scopeOpen()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket answered() {@see Modules\Tickets\Models\Ticket::scopeAnswered()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket closed() {@see Modules\Tickets\Models\Ticket::scopeClosed()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket highPriority() {@see Modules\Tickets\Models\Ticket::scopeHighPriority()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Ticket extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * Modules\Tickets\Models\Department
	 *
	 * @property array|null $assignee_id
	 * @property boolean $status
	 * @property string|null $description
	 * @property string $name
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read mixed $translated_name
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Modules\Tickets\Models\Ticket> $tickets
	 * @property-read int|null $tickets_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Modules\Tickets\Models\DepartmentTranslation> $translations
	 * @property-read int|null $translations_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Department>|Department whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Department>|Department whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Department>|Department whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Department>|Department whereStatus($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Department>|Department whereAssigneeId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Department>|Department newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Department>|Department newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Department>|Department query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Department>|Department active() {@see Modules\Tickets\Models\Department::scopeActive()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Department>|Department inactive() {@see Modules\Tickets\Models\Department::scopeInactive()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Department extends \App\Models\BaseModel
	{
		//
	}

}

namespace App\Models {

	/**
	 * App\Models\BaseModel
	 *
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class BaseModel extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\Plan
	 *
	 * @property int|null $currency_id
	 * @property string|null $color
	 * @property boolean $featured
	 * @property boolean $is_free
	 * @property boolean $is_active
	 * @property integer $interval
	 * @property integer $trial_days
	 * @property string $billing_period
	 * @property int $yearly_discount
	 * @property float $yearly_price
	 * @property float $price
	 * @property string|null $description
	 * @property string $slug
	 * @property string $name
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read mixed $formatted_price
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PlanFeature> $planFeatures
	 * @property-read int|null $planFeatures_count
	 * @property-read \App\Models\Currency $currency
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Subscription> $subscriptions
	 * @property-read int|null $subscriptions_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan whereSlug($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan wherePrice($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan whereYearlyPrice($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan whereYearlyDiscount($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan whereBillingPeriod($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan whereTrialDays($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan whereInterval($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan whereIsActive($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan whereIsFree($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan whereFeatured($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan whereColor($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan whereCurrencyId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan active() {@see App\Models\Plan::scopeActive()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Plan>|Plan visible() {@see App\Models\Plan::scopeVisible()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Plan extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant
	 *
	 * @property \Illuminate\Support\Carbon|null $deleted_date
	 * @property \Illuminate\Support\Carbon|null $expires_at
	 * @property string|null $billing_phone
	 * @property string|null $billing_country
	 * @property string|null $billing_zip_code
	 * @property string|null $billing_state
	 * @property string|null $billing_city
	 * @property string|null $billing_address
	 * @property string|null $billing_email
	 * @property string|null $billing_name
	 * @property array|null $payment_details
	 * @property string|null $payment_method
	 * @property int|null $country_id
	 * @property string|null $address
	 * @property array|null $features_config
	 * @property boolean|null $has_custom_domain
	 * @property string|null $timezone
	 * @property array|null $custom_colors
	 * @property mixed $status
	 * @property string|null $stripe_customer_id
	 * @property string $subdomain
	 * @property string|null $company_name
	 * @property int $id
	 * @property-read mixed $domain
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read mixed $url
	 * @property-read mixed $formatted_status
	 * @property-read mixed $status_badge
	 * @property-read \App\Models\Subscription $activeSubscription
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Subscription> $subscriptions
	 * @property-read int|null $subscriptions_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Corbital\Settings\Models\TenantSetting> $settings
	 * @property-read int|null $settings_count
	 * @property-read \App\Models\User $adminUser
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Modules\Tickets\Models\Ticket> $tickets
	 * @property-read int|null $tickets_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PaymentMethod> $paymentMethods
	 * @property-read int|null $paymentMethods_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereCompanyName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereSubdomain($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereStripeCustomerId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereStatus($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereCustomColors($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereTimezone($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereHasCustomDomain($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereFeaturesConfig($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereAddress($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereCountryId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant wherePaymentMethod($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant wherePaymentDetails($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingEmail($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingAddress($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingCity($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingState($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingZipCode($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingCountry($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingPhone($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereExpiresAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereDeletedDate($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Tenant extends \Spatie\Multitenancy\Models\Tenant
	{
		//
	}

	/**
	 * App\Models\Feature
	 *
	 * @property boolean $default
	 * @property integer $display_order
	 * @property string|null $icon
	 * @property mixed $type
	 * @property string|null $description
	 * @property string $slug
	 * @property string $name
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Plan> $plans
	 * @property-read int|null $plans_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Tenant\FeatureUsage> $usages
	 * @property-read int|null $usages_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\FeatureLimit> $limits
	 * @property-read int|null $limits_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Feature>|Feature whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Feature>|Feature whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Feature>|Feature whereSlug($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Feature>|Feature whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Feature>|Feature whereType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Feature>|Feature whereIcon($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Feature>|Feature whereDisplayOrder($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Feature>|Feature whereDefault($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Feature>|Feature newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Feature>|Feature newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Feature>|Feature query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Feature>|Feature boolean() {@see App\Models\Feature::scopeBoolean()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Feature>|Feature limit() {@see App\Models\Feature::scopeLimit()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Feature>|Feature ordered() {@see App\Models\Feature::scopeOrdered()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Feature extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Currency
	 *
	 * @property boolean $is_default
	 * @property float|null $exchange_rate
	 * @property string|null $format
	 * @property string $symbol
	 * @property string $code
	 * @property string $name
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @method static \Illuminate\Database\Eloquent\Builder<Currency>|Currency whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Currency>|Currency whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Currency>|Currency whereCode($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Currency>|Currency whereSymbol($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Currency>|Currency whereFormat($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Currency>|Currency whereExchangeRate($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Currency>|Currency whereIsDefault($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Currency>|Currency newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Currency>|Currency newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Currency>|Currency query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Currency>|Currency default() {@see App\Models\Currency::scopeDefault()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Currency extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Subscription
	 *
	 * @property string|null $last_payment_attempt_at
	 * @property int $payment_attempt_count
	 * @property string|null $cancellation_reason
	 * @property string|null $canceled_at
	 * @property \Illuminate\Support\Carbon|null $terminated_at
	 * @property \Illuminate\Support\Carbon|null $ended_at
	 * @property \Illuminate\Support\Carbon|null $cancelled_at
	 * @property boolean $is_recurring
	 * @property \Illuminate\Support\Carbon|null $trial_ends_at
	 * @property string|null $trial_starts_at
	 * @property \Illuminate\Support\Carbon|null $current_period_ends_at
	 * @property mixed $status
	 * @property int $plan_id
	 * @property int $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Plan $plan
	 * @property-read \App\Models\Tenant $tenant
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Invoice\Invoice> $invoices
	 * @property-read int|null $invoices_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\SubscriptionLog> $subscriptionLogs
	 * @property-read int|null $subscriptionLogs_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Transaction> $transactions
	 * @property-read int|null $transactions_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription wherePlanId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereStatus($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereCurrentPeriodEndsAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereTrialStartsAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereTrialEndsAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereIsRecurring($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereCancelledAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereEndedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereTerminatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereCanceledAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereCancellationReason($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription wherePaymentAttemptCount($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereLastPaymentAttemptAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription new() {@see App\Models\Subscription::scopeNew()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription active() {@see App\Models\Subscription::scopeActive()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription ended() {@see App\Models\Subscription::scopeEnded()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription cancelled() {@see App\Models\Subscription::scopeCancelled()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription terminated() {@see App\Models\Subscription::scopeTerminated()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription trial() {@see App\Models\Subscription::scopeTrial()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription pause() {@see App\Models\Subscription::scopePause()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription newOrActive() {@see App\Models\Subscription::scopeNewOrActive()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Subscription extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Language
	 *
	 * @property bool|null $status
	 * @property string $code
	 * @property string $name
	 * @property int|null $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read mixed $file_path
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<Language>|Language whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Language>|Language whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Language>|Language whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Language>|Language whereCode($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Language>|Language whereStatus($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Language>|Language newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Language>|Language newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Language>|Language query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Language extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Coupon
	 *
	 * @property int|null $created_by
	 * @property boolean $is_active
	 * @property boolean $first_payment_only
	 * @property array|null $applicable_billing_periods
	 * @property array|null $applicable_plans
	 * @property float|null $maximum_discount
	 * @property float|null $minimum_amount
	 * @property \Illuminate\Support\Carbon|null $expires_at
	 * @property \Illuminate\Support\Carbon|null $starts_at
	 * @property int|null $usage_limit_per_customer
	 * @property int $usage_count
	 * @property int|null $usage_limit
	 * @property float $value
	 * @property mixed $type
	 * @property string|null $description
	 * @property string $name
	 * @property string $code
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\CouponUsage> $usages
	 * @property-read int|null $usages_count
	 * @property-read \App\Models\User $createdBy
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereCode($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereValue($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereUsageLimit($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereUsageCount($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereUsageLimitPerCustomer($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereStartsAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereExpiresAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereMinimumAmount($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereMaximumDiscount($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereApplicablePlans($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereApplicableBillingPeriods($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereFirstPaymentOnly($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereIsActive($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon whereCreatedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon active() {@see App\Models\Coupon::scopeActive()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Coupon>|Coupon valid() {@see App\Models\Coupon::scopeValid()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Coupon extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\CouponUsage
	 *
	 * @property array|null $metadata
	 * @property float $discount_amount
	 * @property int|null $subscription_id
	 * @property int|null $invoice_id
	 * @property int $tenant_id
	 * @property int $coupon_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read mixed $formatted_discount
	 * @property-read \App\Models\Coupon $coupon
	 * @property-read \App\Models\Tenant $tenant
	 * @property-read \App\Models\Invoice\Invoice $invoice
	 * @property-read \App\Models\Subscription $subscription
	 * @method static \Illuminate\Database\Eloquent\Builder<CouponUsage>|CouponUsage whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CouponUsage>|CouponUsage whereCouponId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CouponUsage>|CouponUsage whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CouponUsage>|CouponUsage whereInvoiceId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CouponUsage>|CouponUsage whereSubscriptionId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CouponUsage>|CouponUsage whereDiscountAmount($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CouponUsage>|CouponUsage whereMetadata($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CouponUsage>|CouponUsage newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<CouponUsage>|CouponUsage newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<CouponUsage>|CouponUsage query()
	 * @method static \Illuminate\Database\Eloquent\Builder<CouponUsage>|CouponUsage forTenant(int $tenantId) {@see App\Models\CouponUsage::scopeForTenant()}
	 * @method static \Illuminate\Database\Eloquent\Builder<CouponUsage>|CouponUsage forCoupon(int $couponId) {@see App\Models\CouponUsage::scopeForCoupon()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class CouponUsage extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\CreditTransaction
	 *
	 * @property int|null $invoice_id
	 * @property array|null $metadata
	 * @property string $description
	 * @property int $currency_id
	 * @property float $amount
	 * @property mixed $type
	 * @property int $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @property-read \App\Models\Currency $currency
	 * @property-read \App\Models\Invoice\Invoice $invoice
	 * @method static \Illuminate\Database\Eloquent\Builder<CreditTransaction>|CreditTransaction whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CreditTransaction>|CreditTransaction whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CreditTransaction>|CreditTransaction whereType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CreditTransaction>|CreditTransaction whereAmount($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CreditTransaction>|CreditTransaction whereCurrencyId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CreditTransaction>|CreditTransaction whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CreditTransaction>|CreditTransaction whereMetadata($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CreditTransaction>|CreditTransaction whereInvoiceId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CreditTransaction>|CreditTransaction newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<CreditTransaction>|CreditTransaction newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<CreditTransaction>|CreditTransaction query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class CreditTransaction extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\EmailTemplate
	 *
	 * @property int|null $updated_by
	 * @property int|null $created_by
	 * @property boolean $use_layout
	 * @property int|null $layout_id
	 * @property string|null $type
	 * @property string|null $category
	 * @property boolean $is_system
	 * @property boolean $is_active
	 * @property array|null $merge_fields_groups
	 * @property array|null $variables
	 * @property string|null $content
	 * @property string $subject
	 * @property string|null $description
	 * @property string $slug
	 * @property string $name
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \Corbital\LaravelEmails\Models\EmailLayout $layout
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereSlug($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereSubject($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereContent($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereVariables($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereMergeFieldsGroups($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereIsActive($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereIsSystem($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereCategory($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereLayoutId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereUseLayout($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereCreatedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereUpdatedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class EmailTemplate extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Faq
	 *
	 * @property int $sort_order
	 * @property boolean|null $is_visible
	 * @property string $answer
	 * @property string $question
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @method static \Illuminate\Database\Eloquent\Builder<Faq>|Faq whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Faq>|Faq whereQuestion($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Faq>|Faq whereAnswer($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Faq>|Faq whereIsVisible($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Faq>|Faq whereSortOrder($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Faq>|Faq newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Faq>|Faq newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Faq>|Faq query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Faq extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\FeatureLimit
	 *
	 * @property \Illuminate\Support\Carbon|null $expires_at
	 * @property string|null $reason
	 * @property string $custom_limit
	 * @property int $tenant_id
	 * @property int $feature_id
	 * @property int $plan_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Plan $plan
	 * @property-read \App\Models\Feature $feature
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureLimit>|FeatureLimit whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureLimit>|FeatureLimit wherePlanId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureLimit>|FeatureLimit whereFeatureId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureLimit>|FeatureLimit whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureLimit>|FeatureLimit whereCustomLimit($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureLimit>|FeatureLimit whereReason($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureLimit>|FeatureLimit whereExpiresAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureLimit>|FeatureLimit newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureLimit>|FeatureLimit newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureLimit>|FeatureLimit query()
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureLimit>|FeatureLimit active() {@see App\Models\FeatureLimit::scopeActive()}
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureLimit>|FeatureLimit expired() {@see App\Models\FeatureLimit::scopeExpired()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class FeatureLimit extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Page
	 *
	 * @property integer|null $order
	 * @property int|null $parent_id
	 * @property boolean|null $status
	 * @property boolean|null $show_in_menu
	 * @property string|null $description
	 * @property string $slug
	 * @property string $title
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Page $parent
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Page> $children
	 * @property-read int|null $children_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereTitle($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereSlug($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereShowInMenu($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereStatus($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereParentId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereOrder($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page active() {@see App\Models\Page::scopeActive()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page inMenu() {@see App\Models\Page::scopeInMenu()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Page extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\PaymentMethod
	 *
	 * @property array|null $metadata
	 * @property boolean $is_default
	 * @property string|null $payment_method_id
	 * @property string $type
	 * @property int $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod wherePaymentMethodId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereIsDefault($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereMetadata($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod query()
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod default() {@see App\Models\PaymentMethod::scopeDefault()}
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod ofType(string $type) {@see App\Models\PaymentMethod::scopeOfType()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class PaymentMethod extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\PaymentWebhook
	 *
	 * @property \Illuminate\Support\Carbon|null $last_pinged_at
	 * @property array|null $metadata
	 * @property array|null $events
	 * @property boolean $is_active
	 * @property string|null $secret
	 * @property string $endpoint_url
	 * @property string|null $webhook_id
	 * @property string $provider
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentWebhook>|PaymentWebhook whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentWebhook>|PaymentWebhook whereProvider($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentWebhook>|PaymentWebhook whereWebhookId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentWebhook>|PaymentWebhook whereEndpointUrl($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentWebhook>|PaymentWebhook whereSecret($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentWebhook>|PaymentWebhook whereIsActive($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentWebhook>|PaymentWebhook whereEvents($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentWebhook>|PaymentWebhook whereMetadata($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentWebhook>|PaymentWebhook whereLastPingedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentWebhook>|PaymentWebhook newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentWebhook>|PaymentWebhook newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentWebhook>|PaymentWebhook query()
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentWebhook>|PaymentWebhook active() {@see App\Models\PaymentWebhook::scopeActive()}
	 * @method static \Illuminate\Database\Eloquent\Builder<PaymentWebhook>|PaymentWebhook forProvider(mixed $provider) {@see App\Models\PaymentWebhook::scopeForProvider()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class PaymentWebhook extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\PlanFeature
	 *
	 * @property string|null $resettable_interval
	 * @property integer|null $resettable_period
	 * @property string $value
	 * @property string|null $description
	 * @property string|null $slug
	 * @property string|null $name
	 * @property integer|null $feature_id
	 * @property integer $plan_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read mixed $formatted_value
	 * @property-read \App\Models\Plan $plan
	 * @property-read \App\Models\Feature $feature
	 * @method static \Illuminate\Database\Eloquent\Builder<PlanFeature>|PlanFeature whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PlanFeature>|PlanFeature wherePlanId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PlanFeature>|PlanFeature whereFeatureId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PlanFeature>|PlanFeature whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PlanFeature>|PlanFeature whereSlug($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PlanFeature>|PlanFeature whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PlanFeature>|PlanFeature whereValue($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PlanFeature>|PlanFeature whereResettablePeriod($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PlanFeature>|PlanFeature whereResettableInterval($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PlanFeature>|PlanFeature newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<PlanFeature>|PlanFeature newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<PlanFeature>|PlanFeature query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class PlanFeature extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\SubscriptionLog
	 *
	 * @property array|null $data
	 * @property int|null $transaction_id
	 * @property string|null $description
	 * @property string $type
	 * @property int $subscription_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Subscription $subscription
	 * @property-read \App\Models\Transaction $transaction
	 * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionLog>|SubscriptionLog whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionLog>|SubscriptionLog whereSubscriptionId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionLog>|SubscriptionLog whereType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionLog>|SubscriptionLog whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionLog>|SubscriptionLog whereTransactionId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionLog>|SubscriptionLog whereData($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionLog>|SubscriptionLog newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionLog>|SubscriptionLog newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionLog>|SubscriptionLog query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class SubscriptionLog extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tax
	 *
	 * @property string|null $description
	 * @property float $rate
	 * @property string $name
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @method static \Illuminate\Database\Eloquent\Builder<Tax>|Tax whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tax>|Tax whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tax>|Tax whereRate($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tax>|Tax whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tax>|Tax newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Tax>|Tax newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Tax>|Tax query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Tax extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\TenantCreditBalance
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property int $currency_id
	 * @property float $balance
	 * @property int $tenant_id
	 * @property int $id
	 * @property-read \App\Models\Tenant $tenant
	 * @property-read \App\Models\Currency $currency
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantCreditBalance>|TenantCreditBalance whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantCreditBalance>|TenantCreditBalance whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantCreditBalance>|TenantCreditBalance whereBalance($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantCreditBalance>|TenantCreditBalance whereCurrencyId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantCreditBalance>|TenantCreditBalance whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantCreditBalance>|TenantCreditBalance whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantCreditBalance>|TenantCreditBalance newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantCreditBalance>|TenantCreditBalance newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantCreditBalance>|TenantCreditBalance query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class TenantCreditBalance extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\TenantLanguage
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string $code
	 * @property string $name
	 * @property int $id
	 * @property-read mixed $file_path
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantLanguage>|TenantLanguage whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantLanguage>|TenantLanguage whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantLanguage>|TenantLanguage whereCode($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantLanguage>|TenantLanguage whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantLanguage>|TenantLanguage whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantLanguage>|TenantLanguage newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantLanguage>|TenantLanguage newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<TenantLanguage>|TenantLanguage query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class TenantLanguage extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\Theme
	 *
	 * @property string|null $theme_url
	 * @property string|null $version
	 * @property boolean $active
	 * @property string $folder
	 * @property mixed $type
	 * @property string|null $theme_css
	 * @property string|null $theme_html
	 * @property string|null $payload
	 * @property string $name
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @method static \Illuminate\Database\Eloquent\Builder<Theme>|Theme whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Theme>|Theme whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Theme>|Theme wherePayload($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Theme>|Theme whereThemeHtml($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Theme>|Theme whereThemeCss($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Theme>|Theme whereType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Theme>|Theme whereFolder($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Theme>|Theme whereActive($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Theme>|Theme whereVersion($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Theme>|Theme whereThemeUrl($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Theme>|Theme newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Theme>|Theme newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Theme>|Theme query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Theme extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Transaction
	 *
	 * @property array|null $metadata
	 * @property string|null $error
	 * @property string|null $description
	 * @property int $currency_id
	 * @property string|null $idempotency_key
	 * @property float $amount
	 * @property mixed $status
	 * @property string $type
	 * @property int|null $payment_method_id
	 * @property int $invoice_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Invoice\Invoice $invoice
	 * @property-read \App\Models\PaymentMethod $paymentMethod
	 * @property-read \App\Models\Currency $currency
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereInvoiceId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction wherePaymentMethodId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereStatus($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereAmount($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereIdempotencyKey($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereCurrencyId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereError($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereMetadata($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction pending() {@see App\Models\Transaction::scopePending()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction successful() {@see App\Models\Transaction::scopeSuccessful()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction failed() {@see App\Models\Transaction::scopeFailed()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Transaction extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\UploadedFile
	 *
	 * @property string $url
	 * @property string $path
	 * @property string $type
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @method static \Illuminate\Database\Eloquent\Builder<UploadedFile>|UploadedFile whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UploadedFile>|UploadedFile whereType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UploadedFile>|UploadedFile wherePath($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UploadedFile>|UploadedFile whereUrl($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<UploadedFile>|UploadedFile newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<UploadedFile>|UploadedFile newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<UploadedFile>|UploadedFile query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class UploadedFile extends \App\Models\BaseModel
	{
		//
	}

}

namespace Spatie\Multitenancy\Models {

	/**
	 * Spatie\Multitenancy\Models\Tenant
	 *
	 * @property string|null $deleted_date
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string|null $expires_at
	 * @property string|null $billing_phone
	 * @property string|null $billing_country
	 * @property string|null $billing_zip_code
	 * @property string|null $billing_state
	 * @property string|null $billing_city
	 * @property string|null $billing_address
	 * @property string|null $billing_email
	 * @property string|null $billing_name
	 * @property string|null $payment_details
	 * @property string|null $payment_method
	 * @property int|null $country_id
	 * @property string|null $address
	 * @property string|null $features_config
	 * @property bool|null $has_custom_domain
	 * @property string|null $timezone
	 * @property string|null $custom_colors
	 * @property mixed $status
	 * @property string|null $stripe_customer_id
	 * @property string $subdomain
	 * @property string|null $domain
	 * @property string|null $company_name
	 * @property int $id
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereCompanyName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereDomain($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereSubdomain($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereStripeCustomerId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereStatus($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereCustomColors($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereTimezone($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereHasCustomDomain($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereFeaturesConfig($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereAddress($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereCountryId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant wherePaymentMethod($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant wherePaymentDetails($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingEmail($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingAddress($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingCity($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingState($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingZipCode($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingCountry($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereBillingPhone($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereExpiresAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant whereDeletedDate($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Tenant>|Tenant query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Tenant extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

}

namespace Spatie\Permission\Models {

	/**
	 * Spatie\Permission\Models\Role
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string $guard_name
	 * @property string $name
	 * @property int|null $tenant_id
	 * @property int $id
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Permission> $permissions
	 * @property-read int|null $permissions_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\User> $users
	 * @property-read int|null $users_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereGuardName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role permission(mixed $permissions, mixed $without = false) {@see Spatie\Permission\Models\Role::scopePermission()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role withoutPermission(mixed $permissions) {@see Spatie\Permission\Models\Role::scopeWithoutPermission()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Role extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * Spatie\Permission\Models\Permission
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property string $scope
	 * @property string $guard_name
	 * @property string $name
	 * @property int $id
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Role> $roles
	 * @property-read int|null $roles_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\User> $users
	 * @property-read int|null $users_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\Permission\Models\Permission> $permissions
	 * @property-read int|null $permissions_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereGuardName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereScope($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission role(mixed $roles, mixed $guard = null, mixed $without = false) {@see Spatie\Permission\Models\Permission::scopeRole()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission withoutRole(mixed $roles, mixed $guard = null) {@see Spatie\Permission\Models\Permission::scopeWithoutRole()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission permission(mixed $permissions, mixed $without = false) {@see Spatie\Permission\Models\Permission::scopePermission()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission withoutPermission(mixed $permissions) {@see Spatie\Permission\Models\Permission::scopeWithoutPermission()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Permission extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

}

namespace App\Models\Tenant {

	/**
	 * App\Models\Tenant\Contact
	 *
	 * @property-read mixed $country_name
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant\Source $source
	 * @property-read \App\Models\Tenant\Status $status
	 * @property-read \App\Models\Tenant $tenant
	 * @property-read \App\Models\Tenant\Group $group
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Tenant\ContactNote> $contact_notes
	 * @property-read int|null $contact_notes_count
	 * @property-read \App\Models\User $user
	 * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact inGroup(mixed $groupId) {@see App\Models\Tenant\Contact::scopeInGroup()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact inAnyGroup(array $groupIds) {@see App\Models\Tenant\Contact::scopeInAnyGroup()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact inAllGroups(array $groupIds) {@see App\Models\Tenant\Contact::scopeInAllGroups()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereCustomField(string $fieldName, mixed $value) {@see App\Models\Tenant\Contact::scopeWhereCustomField()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereHasCustomField(string $fieldName) {@see App\Models\Tenant\Contact::scopeWhereHasCustomField()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact searchCustomFields(string $searchTerm) {@see App\Models\Tenant\Contact::scopeSearchCustomFields()}
	 * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact forTenant(mixed $tenant) {@see App\Models\Tenant\Contact::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Contact extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\AiPrompt
	 *
	 * @property string $action
	 * @property string $name
	 * @property int|null $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<AiPrompt>|AiPrompt whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AiPrompt>|AiPrompt whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AiPrompt>|AiPrompt whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AiPrompt>|AiPrompt whereAction($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<AiPrompt>|AiPrompt newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<AiPrompt>|AiPrompt newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<AiPrompt>|AiPrompt query()
	 * @method static \Illuminate\Database\Eloquent\Builder<AiPrompt>|AiPrompt forTenant(mixed $tenant) {@see App\Models\Tenant\AiPrompt::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class AiPrompt extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\ApiToken
	 *
	 * @property-read \App\Models\User $user
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<ApiToken>|ApiToken newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<ApiToken>|ApiToken newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<ApiToken>|ApiToken query()
	 * @method static \Illuminate\Database\Eloquent\Builder<ApiToken>|ApiToken forTenant(mixed $tenant) {@see App\Models\Tenant\ApiToken::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class ApiToken extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\Tenant\BotFlow
	 *
	 * @property boolean $is_active
	 * @property string|null $flow_data
	 * @property string|null $description
	 * @property string $name
	 * @property integer|null $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<BotFlow>|BotFlow whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<BotFlow>|BotFlow whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<BotFlow>|BotFlow whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<BotFlow>|BotFlow whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<BotFlow>|BotFlow whereFlowData($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<BotFlow>|BotFlow whereIsActive($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<BotFlow>|BotFlow newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<BotFlow>|BotFlow newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<BotFlow>|BotFlow query()
	 * @method static \Illuminate\Database\Eloquent\Builder<BotFlow>|BotFlow forTenant(mixed $tenant) {@see App\Models\Tenant\BotFlow::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class BotFlow extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\Campaign
	 *
	 * @property string|null $rel_data
	 * @property string|null $filename
	 * @property int $sending_count
	 * @property bool $is_sent
	 * @property bool $select_all
	 * @property bool $pause_campaign
	 * @property string|null $footer_params
	 * @property string|null $body_params
	 * @property string|null $header_params
	 * @property bool $send_now
	 * @property \Illuminate\Support\Carbon|null $scheduled_send_time
	 * @property string|null $template_id
	 * @property string $rel_type
	 * @property string $name
	 * @property int $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Tenant\CampaignDetail> $campaign_details
	 * @property-read int|null $campaign_details_count
	 * @property-read \App\Models\Tenant\WhatsappTemplate $whatsappTemplate
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereRelType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereTemplateId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereScheduledSendTime($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereSendNow($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereHeaderParams($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereBodyParams($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereFooterParams($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign wherePauseCampaign($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereSelectAll($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereIsSent($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereSendingCount($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereFilename($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign whereRelData($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Campaign>|Campaign forTenant(mixed $tenant) {@see App\Models\Tenant\Campaign::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Campaign extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\CampaignDetail
	 *
	 * @property string|null $message_status
	 * @property string|null $whatsapp_id
	 * @property string|null $response_message
	 * @property int|null $status
	 * @property string|null $footer_message
	 * @property string|null $body_message
	 * @property string|null $header_message
	 * @property string $rel_type
	 * @property int|null $rel_id
	 * @property int $campaign_id
	 * @property int $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant\Campaign $campaign
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail whereCampaignId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail whereRelId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail whereRelType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail whereHeaderMessage($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail whereBodyMessage($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail whereFooterMessage($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail whereStatus($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail whereResponseMessage($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail whereWhatsappId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail whereMessageStatus($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<CampaignDetail>|CampaignDetail query()
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class CampaignDetail extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\CannedReply
	 *
	 * @property int $added_from
	 * @property bool $is_public
	 * @property string $description
	 * @property string $title
	 * @property int $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<CannedReply>|CannedReply whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CannedReply>|CannedReply whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CannedReply>|CannedReply whereTitle($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CannedReply>|CannedReply whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CannedReply>|CannedReply whereIsPublic($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CannedReply>|CannedReply whereAddedFrom($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CannedReply>|CannedReply newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<CannedReply>|CannedReply newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<CannedReply>|CannedReply query()
	 * @method static \Illuminate\Database\Eloquent\Builder<CannedReply>|CannedReply forTenant(mixed $tenant) {@see App\Models\Tenant\CannedReply::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class CannedReply extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\Chat
	 *
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Tenant\ChatMessage> $messages
	 * @property-read int|null $messages_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Chat>|Chat newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Chat>|Chat newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Chat>|Chat query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Chat>|Chat forTenant(mixed $tenant) {@see App\Models\Tenant\Chat::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Chat extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\ChatMessage
	 *
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @property-read \App\Models\Tenant\Chat $chat
	 * @method static \Illuminate\Database\Eloquent\Builder<ChatMessage>|ChatMessage newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<ChatMessage>|ChatMessage newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<ChatMessage>|ChatMessage query()
	 * @method static \Illuminate\Database\Eloquent\Builder<ChatMessage>|ChatMessage forTenant(mixed $tenant) {@see App\Models\Tenant\ChatMessage::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class ChatMessage extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\ContactImport
	 *
	 * @property \Illuminate\Support\Carbon|null $updated_at
	 * @property \Illuminate\Support\Carbon|null $created_at
	 * @property array|null $error_messages
	 * @property string $status
	 * @property integer $skipped_records
	 * @property integer $invalid_records
	 * @property integer $valid_records
	 * @property integer $processed_records
	 * @property integer $total_records
	 * @property string $file_path
	 * @property int $tenant_id
	 * @property int $id
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport whereFilePath($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport whereTotalRecords($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport whereProcessedRecords($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport whereValidRecords($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport whereInvalidRecords($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport whereSkippedRecords($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport whereStatus($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport whereErrorMessages($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport whereCreatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport whereUpdatedAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport query()
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport processing() {@see App\Models\Tenant\ContactImport::scopeProcessing()}
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport completed() {@see App\Models\Tenant\ContactImport::scopeCompleted()}
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport failed() {@see App\Models\Tenant\ContactImport::scopeFailed()}
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactImport>|ContactImport forTenant(mixed $tenant) {@see App\Models\Tenant\ContactImport::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class ContactImport extends \Illuminate\Database\Eloquent\Model
	{
		//
	}

	/**
	 * App\Models\Tenant\ContactNote
	 *
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant\Contact $contact
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactNote>|ContactNote newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactNote>|ContactNote newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactNote>|ContactNote query()
	 * @method static \Illuminate\Database\Eloquent\Builder<ContactNote>|ContactNote forTenant(mixed $tenant) {@see App\Models\Tenant\ContactNote::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class ContactNote extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\CustomField
	 *
	 * @property boolean $show_on_table
	 * @property boolean $is_active
	 * @property integer $display_order
	 * @property string|null $default_value
	 * @property boolean $is_required
	 * @property string|null $description
	 * @property string|null $placeholder
	 * @property array|null $field_options
	 * @property mixed $field_type
	 * @property string $field_label
	 * @property string $field_name
	 * @property integer $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read mixed $field_type_label
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField whereFieldName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField whereFieldLabel($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField whereFieldType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField whereFieldOptions($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField wherePlaceholder($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField whereIsRequired($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField whereDefaultValue($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField whereDisplayOrder($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField whereIsActive($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField whereShowOnTable($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField query()
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField active() {@see App\Models\Tenant\CustomField::scopeActive()}
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField ordered() {@see App\Models\Tenant\CustomField::scopeOrdered()}
	 * @method static \Illuminate\Database\Eloquent\Builder<CustomField>|CustomField forTenant(mixed $tenant) {@see App\Models\Tenant\CustomField::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class CustomField extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\EmailTemplate
	 *
	 * @property int|null $updated_by
	 * @property int|null $created_by
	 * @property bool $use_layout
	 * @property int|null $layout_id
	 * @property string|null $type
	 * @property string|null $category
	 * @property bool $is_system
	 * @property int $is_active
	 * @property array|null $merge_fields_groups
	 * @property string|null $variables
	 * @property string|null $content
	 * @property string $subject
	 * @property string|null $description
	 * @property string $slug
	 * @property string $name
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereSlug($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereSubject($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereContent($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereVariables($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereMergeFieldsGroups($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereIsActive($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereIsSystem($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereCategory($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereLayoutId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereUseLayout($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereCreatedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereUpdatedBy($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate query()
	 * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate forTenant(mixed $tenant) {@see App\Models\Tenant\EmailTemplate::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class EmailTemplate extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\FeatureUsage
	 *
	 * @property \Illuminate\Support\Carbon|null $last_reset_at
	 * @property \Illuminate\Support\Carbon|null $period_start
	 * @property \Illuminate\Support\Carbon|null $reset_date
	 * @property int $used
	 * @property int $limit_value
	 * @property string $feature_slug
	 * @property int $subscription_id
	 * @property int $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Subscription $subscription
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureUsage>|FeatureUsage whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureUsage>|FeatureUsage whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureUsage>|FeatureUsage whereSubscriptionId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureUsage>|FeatureUsage whereFeatureSlug($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureUsage>|FeatureUsage whereLimitValue($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureUsage>|FeatureUsage whereUsed($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureUsage>|FeatureUsage whereResetDate($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureUsage>|FeatureUsage wherePeriodStart($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureUsage>|FeatureUsage whereLastResetAt($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureUsage>|FeatureUsage newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureUsage>|FeatureUsage newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureUsage>|FeatureUsage query()
	 * @method static \Illuminate\Database\Eloquent\Builder<FeatureUsage>|FeatureUsage forTenant(mixed $tenant) {@see App\Models\Tenant\FeatureUsage::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class FeatureUsage extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\Group
	 *
	 * @property string $name
	 * @property int|null $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Tenant\Contact> $contacts
	 * @property-read int|null $contacts_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Group>|Group whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Group>|Group whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Group>|Group whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Group>|Group newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Group>|Group newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Group>|Group query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Group>|Group forTenant(mixed $tenant) {@see App\Models\Tenant\Group::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Group extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\MessageBot
	 *
	 * @property string|null $filename
	 * @property int $sending_count
	 * @property bool $is_bot_active
	 * @property int $addedfrom
	 * @property string|null $button_url
	 * @property string|null $button_name
	 * @property string|null $button3_id
	 * @property string|null $button3
	 * @property string|null $button2_id
	 * @property string|null $button2
	 * @property string|null $button1_id
	 * @property string|null $button1
	 * @property string|null $bot_footer
	 * @property string|null $bot_header
	 * @property string|null $trigger
	 * @property int $reply_type
	 * @property string $reply_text
	 * @property string $rel_type
	 * @property string $name
	 * @property int $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereRelType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereReplyText($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereReplyType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereTrigger($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereBotHeader($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereBotFooter($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereButton1($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereButton1Id($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereButton2($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereButton2Id($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereButton3($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereButton3Id($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereButtonName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereButtonUrl($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereAddedfrom($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereIsBotActive($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereSendingCount($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot whereFilename($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot query()
	 * @method static \Illuminate\Database\Eloquent\Builder<MessageBot>|MessageBot forTenant(mixed $tenant) {@see App\Models\Tenant\MessageBot::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class MessageBot extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\ModelHasPermission
	 *
	 * @property int|null $tenant_id
	 * @property int $model_id
	 * @property string $model_type
	 * @property int $permission_id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant\Permission $permission
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasPermission>|ModelHasPermission wherePermissionId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasPermission>|ModelHasPermission whereModelType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasPermission>|ModelHasPermission whereModelId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasPermission>|ModelHasPermission whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasPermission>|ModelHasPermission newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasPermission>|ModelHasPermission newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasPermission>|ModelHasPermission query()
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasPermission>|ModelHasPermission forTenant(mixed $tenant) {@see App\Models\Tenant\ModelHasPermission::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class ModelHasPermission extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\ModelHasRole
	 *
	 * @property int|null $tenant_id
	 * @property int $model_id
	 * @property string $model_type
	 * @property int $role_id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant\Role $role
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasRole>|ModelHasRole whereRoleId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasRole>|ModelHasRole whereModelType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasRole>|ModelHasRole whereModelId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasRole>|ModelHasRole whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasRole>|ModelHasRole newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasRole>|ModelHasRole newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasRole>|ModelHasRole query()
	 * @method static \Illuminate\Database\Eloquent\Builder<ModelHasRole>|ModelHasRole forTenant(mixed $tenant) {@see App\Models\Tenant\ModelHasRole::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class ModelHasRole extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\Permission
	 *
	 * @property string $scope
	 * @property string $guard_name
	 * @property string $name
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Tenant\ModelHasPermission> $model_has_permissions
	 * @property-read int|null $model_has_permissions_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Tenant\Role> $roles
	 * @property-read int|null $roles_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereGuardName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission whereScope($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Permission>|Permission forTenant(mixed $tenant) {@see App\Models\Tenant\Permission::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Permission extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\PusherNotification
	 *
	 * @property string|null $additional_data
	 * @property string|null $link
	 * @property int|null $fromcompany
	 * @property int $touserid
	 * @property string $from_fullname
	 * @property int $fromclientid
	 * @property int $fromuserid
	 * @property string $description
	 * @property \Illuminate\Support\Carbon $date
	 * @property bool $isread_inline
	 * @property int $isread
	 * @property int|null $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification whereIsread($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification whereIsreadInline($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification whereDate($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification whereDescription($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification whereFromuserid($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification whereFromclientid($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification whereFromFullname($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification whereTouserid($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification whereFromcompany($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification whereLink($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification whereAdditionalData($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification query()
	 * @method static \Illuminate\Database\Eloquent\Builder<PusherNotification>|PusherNotification forTenant(mixed $tenant) {@see App\Models\Tenant\PusherNotification::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class PusherNotification extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\Role
	 *
	 * @property string $guard_name
	 * @property string $name
	 * @property int|null $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Tenant\ModelHasRole> $model_has_roles
	 * @property-read int|null $model_has_roles_count
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Tenant\Permission> $permissions
	 * @property-read int|null $permissions_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role whereGuardName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Role>|Role forTenant(mixed $tenant) {@see App\Models\Tenant\Role::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Role extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\RoleHasPermission
	 *
	 * @property int $role_id
	 * @property int $permission_id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant\Permission $permission
	 * @property-read \App\Models\Tenant\Role $role
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<RoleHasPermission>|RoleHasPermission wherePermissionId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<RoleHasPermission>|RoleHasPermission whereRoleId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<RoleHasPermission>|RoleHasPermission newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<RoleHasPermission>|RoleHasPermission newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<RoleHasPermission>|RoleHasPermission query()
	 * @method static \Illuminate\Database\Eloquent\Builder<RoleHasPermission>|RoleHasPermission forTenant(mixed $tenant) {@see App\Models\Tenant\RoleHasPermission::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class RoleHasPermission extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\Source
	 *
	 * @property string $name
	 * @property int|null $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Tenant\Contact> $contacts
	 * @property-read int|null $contacts_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Source>|Source whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Source>|Source whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Source>|Source whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Source>|Source newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Source>|Source newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Source>|Source query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Source>|Source forTenant(mixed $tenant) {@see App\Models\Tenant\Source::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Source extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\Status
	 *
	 * @property bool $isdefault
	 * @property string $color
	 * @property string $name
	 * @property int|null $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Tenant\Contact> $contacts
	 * @property-read int|null $contacts_count
	 * @method static \Illuminate\Database\Eloquent\Builder<Status>|Status whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Status>|Status whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Status>|Status whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Status>|Status whereColor($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Status>|Status whereIsdefault($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<Status>|Status newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Status>|Status newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<Status>|Status query()
	 * @method static \Illuminate\Database\Eloquent\Builder<Status>|Status forTenant(mixed $tenant) {@see App\Models\Tenant\Status::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
	 * @method static mixed addSelect($column)
	 * @method static mixed distinct()
	 * @method static mixed from($table, $as)
	 * @method static mixed useIndex($index)
	 * @method static mixed forceIndex($index)
	 * @method static mixed ignoreIndex($index)
	 * @method static mixed join($table, $first, $operator, $second, $type, $where)
	 * @method static mixed joinWhere($table, $first, $operator, $second, $type)
	 * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
	 * @method static mixed joinLateral($query, string $as, string $type)
	 * @method static mixed leftJoinLateral($query, string $as)
	 * @method static mixed leftJoin($table, $first, $operator, $second)
	 * @method static mixed leftJoinWhere($table, $first, $operator, $second)
	 * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed rightJoin($table, $first, $operator, $second)
	 * @method static mixed rightJoinWhere($table, $first, $operator, $second)
	 * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
	 * @method static mixed crossJoin($table, $first, $operator, $second)
	 * @method static mixed crossJoinSub($query, $as)
	 * @method static mixed newJoinClause(self $parentQuery, $type, $table)
	 * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
	 * @method static mixed mergeWheres($wheres, $bindings)
	 * @method static mixed where($column, $operator, $value, $boolean)
	 * @method static mixed addArrayOfWheres($column, $boolean, $method)
	 * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
	 * @method static mixed invalidOperatorAndValue($operator, $value)
	 * @method static mixed invalidOperator($operator)
	 * @method static mixed isBitwiseOperator($operator)
	 * @method static mixed orWhere($column, $operator, $value)
	 * @method static mixed whereNot($column, $operator, $value, $boolean)
	 * @method static mixed orWhereNot($column, $operator, $value)
	 * @method static mixed whereColumn($first, $operator, $second, $boolean)
	 * @method static mixed orWhereColumn($first, $operator, $second)
	 * @method static mixed whereRaw($sql, $bindings, $boolean)
	 * @method static mixed orWhereRaw($sql, $bindings)
	 * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
	 * @method static mixed orWhereLike($column, $value, $caseSensitive)
	 * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
	 * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
	 * @method static mixed whereIn($column, $values, $boolean, $not)
	 * @method static mixed orWhereIn($column, $values)
	 * @method static mixed whereNotIn($column, $values, $boolean)
	 * @method static mixed orWhereNotIn($column, $values)
	 * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
	 * @method static mixed orWhereIntegerInRaw($column, $values)
	 * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
	 * @method static mixed orWhereIntegerNotInRaw($column, $values)
	 * @method static mixed whereNull($columns, $boolean, $not)
	 * @method static mixed orWhereNull($column)
	 * @method static mixed whereNotNull($columns, $boolean)
	 * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
	 * @method static mixed orWhereBetween($column, iterable $values)
	 * @method static mixed orWhereBetweenColumns($column, array $values)
	 * @method static mixed whereNotBetween($column, iterable $values, $boolean)
	 * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
	 * @method static mixed orWhereNotBetween($column, iterable $values)
	 * @method static mixed orWhereNotBetweenColumns($column, array $values)
	 * @method static mixed orWhereNotNull($column)
	 * @method static mixed whereDate($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDate($column, $operator, $value)
	 * @method static mixed whereTime($column, $operator, $value, $boolean)
	 * @method static mixed orWhereTime($column, $operator, $value)
	 * @method static mixed whereDay($column, $operator, $value, $boolean)
	 * @method static mixed orWhereDay($column, $operator, $value)
	 * @method static mixed whereMonth($column, $operator, $value, $boolean)
	 * @method static mixed orWhereMonth($column, $operator, $value)
	 * @method static mixed whereYear($column, $operator, $value, $boolean)
	 * @method static mixed orWhereYear($column, $operator, $value)
	 * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
	 * @method static mixed whereNested(Closure $callback, $boolean)
	 * @method static mixed forNestedWhere()
	 * @method static mixed addNestedWhereQuery($query, $boolean)
	 * @method static mixed whereSub($column, $operator, $callback, $boolean)
	 * @method static mixed whereExists($callback, $boolean, $not)
	 * @method static mixed orWhereExists($callback, $not)
	 * @method static mixed whereNotExists($callback, $boolean)
	 * @method static mixed orWhereNotExists($callback)
	 * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
	 * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
	 * @method static mixed orWhereRowValues($columns, $operator, $values)
	 * @method static mixed whereJsonContains($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonContains($column, $value)
	 * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntContain($column, $value)
	 * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
	 * @method static mixed orWhereJsonOverlaps($column, $value)
	 * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
	 * @method static mixed orWhereJsonDoesntOverlap($column, $value)
	 * @method static mixed whereJsonContainsKey($column, $boolean, $not)
	 * @method static mixed orWhereJsonContainsKey($column)
	 * @method static mixed whereJsonDoesntContainKey($column, $boolean)
	 * @method static mixed orWhereJsonDoesntContainKey($column)
	 * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
	 * @method static mixed orWhereJsonLength($column, $operator, $value)
	 * @method static mixed dynamicWhere($method, $parameters)
	 * @method static mixed addDynamic($segment, $connector, $parameters, $index)
	 * @method static mixed whereFullText($columns, $value, array $options, $boolean)
	 * @method static mixed orWhereFullText($columns, $value, array $options)
	 * @method static mixed whereAll($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAll($columns, $operator, $value)
	 * @method static mixed whereAny($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereAny($columns, $operator, $value)
	 * @method static mixed whereNone($columns, $operator, $value, $boolean)
	 * @method static mixed orWhereNone($columns, $operator, $value)
	 * @method static mixed groupBy($groups)
	 * @method static mixed groupByRaw($sql, array $bindings)
	 * @method static mixed having($column, $operator, $value, $boolean)
	 * @method static mixed orHaving($column, $operator, $value)
	 * @method static mixed havingNested(Closure $callback, $boolean)
	 * @method static mixed addNestedHavingQuery($query, $boolean)
	 * @method static mixed havingNull($columns, $boolean, $not)
	 * @method static mixed orHavingNull($column)
	 * @method static mixed havingNotNull($columns, $boolean)
	 * @method static mixed orHavingNotNull($column)
	 * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
	 * @method static mixed havingRaw($sql, array $bindings, $boolean)
	 * @method static mixed orHavingRaw($sql, array $bindings)
	 * @method static mixed orderBy($column, $direction)
	 * @method static mixed orderByDesc($column)
	 * @method static mixed latest($column)
	 * @method static mixed oldest($column)
	 * @method static mixed inRandomOrder($seed)
	 * @method static mixed orderByRaw($sql, $bindings)
	 * @method static mixed skip($value)
	 * @method static mixed offset($value)
	 * @method static mixed take($value)
	 * @method static mixed limit($value)
	 * @method static mixed groupLimit($value, $column)
	 * @method static mixed forPage($page, $perPage)
	 * @method static mixed forPageBeforeId($perPage, $lastId, $column)
	 * @method static mixed forPageAfterId($perPage, $lastId, $column)
	 * @method static mixed reorder($column, $direction)
	 * @method static mixed reorderDesc($column)
	 * @method static mixed removeExistingOrdersFor($column)
	 * @method static mixed union($query, $all)
	 * @method static mixed unionAll($query)
	 * @method static mixed lock($value)
	 * @method static mixed lockForUpdate()
	 * @method static mixed sharedLock()
	 * @method static mixed beforeQuery(callable $callback)
	 * @method static mixed applyBeforeQueryCallbacks()
	 * @method static mixed afterQuery(Closure $callback)
	 * @method static mixed applyAfterQueryCallbacks($result)
	 * @method static mixed toSql()
	 * @method static mixed toRawSql()
	 * @method static mixed find($id, $columns)
	 * @method static mixed findOr($id, $columns, Closure $callback)
	 * @method static mixed value($column)
	 * @method static mixed rawValue(string $expression, array $bindings)
	 * @method static mixed soleValue($column)
	 * @method static mixed get($columns)
	 * @method static mixed runSelect()
	 * @method static mixed withoutGroupLimitKeys($items)
	 * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
	 * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
	 * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed ensureOrderForCursorPagination($shouldReverse)
	 * @method static mixed getCountForPagination($columns)
	 * @method static mixed runPaginationCountQuery($columns)
	 * @method static mixed cloneForPaginationCount()
	 * @method static mixed withoutSelectAliases(array $columns)
	 * @method static mixed cursor()
	 * @method static mixed enforceOrderBy()
	 * @method static mixed pluck($column, $key)
	 * @method static mixed stripTableForPluck($column)
	 * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
	 * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
	 * @method static mixed implode($column, $glue)
	 * @method static mixed exists()
	 * @method static mixed doesntExist()
	 * @method static mixed existsOr(Closure $callback)
	 * @method static mixed doesntExistOr(Closure $callback)
	 * @method static mixed count($columns)
	 * @method static mixed min($column)
	 * @method static mixed max($column)
	 * @method static mixed sum($column)
	 * @method static mixed avg($column)
	 * @method static mixed average($column)
	 * @method static mixed aggregate($function, $columns)
	 * @method static mixed numericAggregate($function, $columns)
	 * @method static mixed setAggregate($function, $columns)
	 * @method static mixed onceWithColumns($columns, $callback)
	 * @method static mixed insert(array $values)
	 * @method static mixed insertOrIgnore(array $values)
	 * @method static mixed insertGetId(array $values, $sequence)
	 * @method static mixed insertUsing(array $columns, $query)
	 * @method static mixed insertOrIgnoreUsing(array $columns, $query)
	 * @method static mixed update(array $values)
	 * @method static mixed updateFrom(array $values)
	 * @method static mixed updateOrInsert(array $attributes, callable|array $values)
	 * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
	 * @method static mixed increment($column, $amount, array $extra)
	 * @method static mixed incrementEach(array $columns, array $extra)
	 * @method static mixed decrement($column, $amount, array $extra)
	 * @method static mixed decrementEach(array $columns, array $extra)
	 * @method static mixed delete($id)
	 * @method static mixed truncate()
	 * @method static mixed newQuery()
	 * @method static mixed forSubQuery()
	 * @method static mixed getColumns()
	 * @method static mixed raw($value)
	 * @method static mixed getUnionBuilders()
	 * @method static mixed getLimit()
	 * @method static mixed getOffset()
	 * @method static mixed getBindings()
	 * @method static mixed getRawBindings()
	 * @method static mixed setBindings(array $bindings, $type)
	 * @method static mixed addBinding($value, $type)
	 * @method static mixed castBinding($value)
	 * @method static mixed mergeBindings(self $query)
	 * @method static mixed cleanBindings(array $bindings)
	 * @method static mixed flattenValue($value)
	 * @method static mixed defaultKeyName()
	 * @method static mixed getConnection()
	 * @method static mixed getProcessor()
	 * @method static mixed getGrammar()
	 * @method static mixed useWritePdo()
	 * @method static mixed isQueryable($value)
	 * @method static mixed clone()
	 * @method static mixed cloneWithout(array $properties)
	 * @method static mixed cloneWithoutBindings(array $except)
	 * @method static mixed dump($args)
	 * @method static mixed dumpRawSql()
	 * @method static mixed dd()
	 * @method static mixed ddRawSql()
	 * @method static mixed wherePast($columns)
	 * @method static mixed whereNowOrPast($columns)
	 * @method static mixed orWherePast($columns)
	 * @method static mixed orWhereNowOrPast($columns)
	 * @method static mixed whereFuture($columns)
	 * @method static mixed whereNowOrFuture($columns)
	 * @method static mixed orWhereFuture($columns)
	 * @method static mixed orWhereNowOrFuture($columns)
	 * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
	 * @method static mixed whereToday($columns, $boolean)
	 * @method static mixed whereBeforeToday($columns)
	 * @method static mixed whereTodayOrBefore($columns)
	 * @method static mixed whereAfterToday($columns)
	 * @method static mixed whereTodayOrAfter($columns)
	 * @method static mixed orWhereToday($columns)
	 * @method static mixed orWhereBeforeToday($columns)
	 * @method static mixed orWhereTodayOrBefore($columns)
	 * @method static mixed orWhereAfterToday($columns)
	 * @method static mixed orWhereTodayOrAfter($columns)
	 * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
	 * @method static mixed chunk($count, callable $callback)
	 * @method static mixed chunkMap(callable $callback, $count)
	 * @method static mixed each(callable $callback, $count)
	 * @method static mixed chunkById($count, callable $callback, $column, $alias)
	 * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
	 * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
	 * @method static mixed eachById(callable $callback, $count, $column, $alias)
	 * @method static mixed lazy($chunkSize)
	 * @method static mixed lazyById($chunkSize, $column, $alias)
	 * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
	 * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
	 * @method static mixed first($columns)
	 * @method static mixed firstOrFail($columns, $message)
	 * @method static mixed sole($columns)
	 * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
	 * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
	 * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
	 * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
	 * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
	 * @method static mixed tap($callback)
	 * @method static mixed pipe($callback)
	 * @method static mixed when($value, callable $callback, callable $default)
	 * @method static mixed unless($value, callable $callback, callable $default)
	 * @method static mixed explain()
	 * @method static mixed forwardCallTo($object, $method, $parameters)
	 * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
	 * @method static mixed throwBadMethodCallException($method)
	 * @method static mixed macro($name, $macro)
	 * @method static mixed mixin($mixin, $replace)
	 * @method static mixed hasMacro($name)
	 * @method static mixed flushMacros()
	 * @method static mixed macroCall($method, $parameters)
	 * @mixin \Illuminate\Database\Query\Builder
	 */
	class Status extends \App\Models\BaseModel
	{
		//
	}

	/**
	 * App\Models\Tenant\TemplateBot
	 *
	 * @property array|null $cards_params
	 * @property int $sending_count
	 * @property int $is_bot_active
	 * @property int $reply_type
	 * @property string|null $trigger
	 * @property string|null $filename
	 * @property string|null $footer_params
	 * @property string|null $body_params
	 * @property string|null $header_params
	 * @property int|null $template_id
	 * @property string $rel_type
	 * @property string $name
	 * @property int $tenant_id
	 * @property int $id
	 * @property-read mixed $created_at
	 * @property-read mixed $updated_at
	 * @property-read \App\Models\Tenant $tenant
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot whereId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot whereTenantId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot whereName($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot whereRelType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot whereTemplateId($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot whereHeaderParams($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot whereBodyParams($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot whereFooterParams($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot whereFilename($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot whereTrigger($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot whereReplyType($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot whereIsBotActive($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot whereSendingCount($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot whereCardsParams($value)
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot newModelQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot newQuery()
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot query()
	 * @method static \Illuminate\Database\Eloquent\Builder<TemplateBot>|TemplateBot forTenant(mixed $tenant) {@see App\Models\Tenant\TemplateBot::scopeForTenant()}
	 * @method static mixed select($columns)
	 * @method static mixed selectSub($query, $as)
	 * @method static mixed selectRaw($expression, array $bindings)
	 * @method static mixed fromSub($query, $as)
	 * @method static mixed fromRaw($expression, $bindings)
	 * @method static mixed createSub($query)
	 * @method static mixed parseSub($query)
	 * @method static mixed prependDatabaseNameIfCrossDatabase