<?php

namespace Corbital\Installer\Classes;

use Carbon\Carbon;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class UpdateChecker
{
    public $url;

    public function __construct()
    {
        
        $this->url = url('/');
    }

    
    public function checkUpdate($token, $mode = 'install')
    {
        return [
            'success' => true,
            'data'    => [
                'latest_version' => config('installer.license_verification.current_version'),
                'update_id'      => null,
                'has_sql_update' => false,
                'message'        => 'You are using the latest version.',
            ],
        ];
    }

    
    public function installVersion($data)
    {
       
        set_settings_batch('whats-mark', [
            'wm_version'            => config('installer.license_verification.current_version'),
            'wm_last_verification'  => now()->timestamp,
            'wm_support_until'      => '2030-12-31', 
        ]);

        return true;
    }

    
    public function downloadUpdate(
        string $updateId,
        bool $needsSqlUpdate,
        string $version,
        string $token,
        ?string $license = null,
        ?string $client = null,
        ?string $mode = 'install'
    ) {
        return [
            'success' => true,
            'message' => 'No update needed (offline mode)',
        ];
    }

   
    public function validateRequest()
    {
        
        if (cache()->has('offline_license_validated')) {
            return true;
        }

        
        cache()->put('offline_license_validated', true, now()->addDays(30));

        
        set_setting('whats-mark.wm_last_verification', now()->timestamp);
        set_setting('whats-mark.wm_validate', true);

        return true;
    }

    
    public function checkSupportExpiryStatus($supportedUntil = '')
    {
        return [
            'success' => true,
            'type'    => 'success',
            'message' => 'Support NOT active',
            'time_diff' => 'Unlimited',
            'support_url' => '#',
        ];
    }

    
    public function getVersionLog()
    {
        return [
            'success' => true,
            'data'    => [
                'version' => config('installer.license_verification.current_version'),
                'changelog' => '<p>Running in offline mode. All license checks have been disabled.</p>',
                'released_at' => now()->toDateString(),
            ],
        ];
    }

    
    private function downloadFile() { return ''; }
    private function extractUpdate() { }
    private function validateZipContents() { }
    private function fileExistsInZip() { return false; }
    private function importSQLFromExtractedFiles() { }
}